<?php

namespace App\Http;

use App\Http\Middleware\Login2FaMiddleware;
use Illuminate\Foundation\Http\Kernel as HttpKernel;

class Kernel extends HttpKernel
{
    /**
     * The application's global HTTP middleware stack.
     *
     * These middleware are run during every request to your application.
     *
     * @var array<int, class-string|string>
     */
    protected $middleware = [
        // \App\Http\Middleware\TrustHosts::class,
        \App\Http\Middleware\TrustProxies::class,
        \Illuminate\Http\Middleware\HandleCors::class,
        \App\Http\Middleware\PreventRequestsDuringMaintenance::class,
        \Illuminate\Foundation\Http\Middleware\ValidatePostSize::class,
        \App\Http\Middleware\TrimStrings::class,
        \Illuminate\Foundation\Http\Middleware\ConvertEmptyStringsToNull::class,
        \Xgenious\Installer\Http\Middleware\InstallerMiddleware::class
    ];

    /**
     * The application's route middleware groups.
     *
     * @var array<string, array<int, class-string|string>>
     */
    protected $middlewareGroups = [
        'web' => [
            \App\Http\Middleware\EncryptCookies::class,
            \Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse::class,
            \Illuminate\Session\Middleware\StartSession::class,
            \Illuminate\View\Middleware\ShareErrorsFromSession::class,
            \App\Http\Middleware\VerifyCsrfToken::class,
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
            \App\Http\Middleware\CheckUserOnlineStatus::class,
            \App\Http\Middleware\DriverConfigMiddleware::class,
        ],

        'api' => [
             \Laravel\Sanctum\Http\Middleware\EnsureFrontendRequestsAreStateful::class,
            'throttle:api',
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
            \App\Http\Middleware\DriverConfigMiddleware::class,
            \App\Http\Middleware\CheckUserOnlineStatus::class,
        ],

    ];

    /**
     * The application's route middleware.
     *
     * These middleware may be assigned to groups or used individually.
     *
     * @var array<string, class-string|string>
     */
    protected $routeMiddleware = [
        'auth' => \App\Http\Middleware\Authenticate::class,
        'auth.basic' => \Illuminate\Auth\Middleware\AuthenticateWithBasicAuth::class,
        'auth.session' => \Illuminate\Session\Middleware\AuthenticateSession::class,
        'cache.headers' => \Illuminate\Http\Middleware\SetCacheHeaders::class,
        'can' => \Illuminate\Auth\Middleware\Authorize::class,
        'guest' => \App\Http\Middleware\RedirectIfAuthenticated::class,
        'password.confirm' => \Illuminate\Auth\Middleware\RequirePassword::class,
        'signed' => \App\Http\Middleware\ValidateSignature::class,
        'throttle' => \Illuminate\Routing\Middleware\ThrottleRequests::class,
        'verified' => \Illuminate\Auth\Middleware\EnsureEmailIsVerified::class,
        'userEmailVerify' => \App\Http\Middleware\UserEmailandPhoneVerify::class,
        '2fa' => \PragmaRX\Google2FALaravel\Middleware::class,
        'Google2FA' => Login2FaMiddleware::class,
        'globalVariable' => \App\Http\Middleware\GlobalVariableMiddleware::class,
        'maintains_mode' => \App\Http\Middleware\MaintainsMode::class,
        'setlang' => \App\Http\Middleware\SetLang::class,
        'role' => \Spatie\Permission\Middleware\RoleMiddleware::class,
        'permission' => \Spatie\Permission\Middleware\PermissionMiddleware::class,
        'preventprojecturl' => \App\Http\Middleware\PreventProjectUrlAccess::class,
        'preventjoburl' => \App\Http\Middleware\PreventJobUrlAccess::class,
        // Project/Job freeze checks
        'checkprojectfreeze' => \App\Http\Middleware\CheckProjectFreeze::class,
        'checkjobfreeze' => \App\Http\Middleware\CheckJobFreeze::class,
        'identityVerified' => \App\Http\Middleware\UserIdentityVerify::class,
    ];
}
