<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class UserIdentityVerify
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        // if identity verification setting is disabled just pass
        $identityVerifySetting = get_static_option('user_identity_verify_enable_disable', 'disable');

        if ($identityVerifySetting === 'disable') {
            if (auth('web')->check()) {
                return $next($request);
            }
        } else {
            if (auth('web')->check()) {
                $user = auth('web')->user();
                $user_type = $user->user_type == 1 ? 'client' : 'influencer';

                if ($user->user_verified_status == 0) {
                    if ($user_type === 'client' && !$request->routeIs('client.identity.verification')) {
                        return redirect()->route('client.identity.verification');
                    }

                    if ($user_type === 'influencer' && !$request->routeIs('influencer.identity.verification')) {
                        return redirect()->route('influencer.identity.verification');
                    }
                }
            }
        }

        return $next($request);
    }
}
