<?php


namespace plugins\PageBuilder\Addons\Job;

use App\Models\JobPost;
use plugins\PageBuilder\Fields\ColorPicker;
use App\Service;
use plugins\PageBuilder\Fields\Slider;
use plugins\PageBuilder\Fields\Number;
use plugins\PageBuilder\Fields\Text;
use plugins\PageBuilder\PageBuilderBase;
use plugins\PageBuilder\Traits\LanguageFallbackForPageBuilder;
use plugins\PageBuilder\Fields\Select;


class LatestJob extends PageBuilderBase
{
    use LanguageFallbackForPageBuilder;

    public function preview_image()
    {
        return 'home-page/latest-campaign.png';
    }

    public function admin_render()
    {
        $output = $this->admin_form_before();
        $output .= $this->admin_form_start();
        $output .= $this->default_fields();
        $widget_saved_values = $this->get_settings();


        $output .= Text::get([
            'name' => 'title',
            'label' => __('Title'),
            'value' => $widget_saved_values['title'] ?? null,
        ]);

        $output .= Number::get([
            'name' => 'items',
            'label' => __('Items'),
            'value' => $widget_saved_values['items'] ?? null,
            'info' => __('enter how many item you want to show in frontend'),
        ]);

        $output .= Text::get([
            'name' => 'find_more_button_text',
            'label' => __('Find more button text'),
            'value' => $widget_saved_values['find_more_button_text'] ?? null,
        ]);

        $output .= Text::get([
            'name' => 'find_more_button_link',
            'label' => __('Find more button link'),
            'value' => $widget_saved_values['find_more_button_link'] ?? null,
        ]);

        $output .= Slider::get([
            'name' => 'padding_top',
            'label' => __('Padding Top'),
            'value' => $widget_saved_values['padding_top'] ?? 260,
            'max' => 500,
        ]);

        $output .= Slider::get([
            'name' => 'padding_bottom',
            'label' => __('Padding Bottom'),
            'value' => $widget_saved_values['padding_bottom'] ?? 190,
            'max' => 500,
        ]);
        $output .= ColorPicker::get([
            'name' => 'section_bg',
            'label' => __('Background Color'),
            'value' => $widget_saved_values['section_bg'] ?? null,
            'info' => __('select color you want to show in frontend'),
        ]);

        $output .= $this->admin_form_submit_button();
        $output .= $this->admin_form_end();
        $output .= $this->admin_form_after();

        return $output;
    }


    public function frontend_render()
    {

        $settings = $this->get_settings();
        $title =$settings['title'];
        $items =$settings['items'] ?? 5;
        $find_more_button_text =$settings['find_more_button_text'];
        $find_more_button_link =$settings['find_more_button_link'];
        $padding_top = $settings['padding_top'];
        $padding_bottom = $settings['padding_bottom'];
        $section_bg = $settings['section_bg'] ?? '';

        $jobs = JobPost::with('job_creator','job_skills')
            ->where('on_off','1')
            ->where('status','1')
            ->where('job_approve_request','1')
            ->whereHas('job_creator')
            ->latest()
            ->take($items)->get();

        return  $this->renderBlade('jobs.latest-job',compact(['title','find_more_button_text','find_more_button_link','padding_top','padding_bottom','section_bg','jobs']));
    }

    public function addon_title()
    {
        return __('Latest Campaigns: 01');
    }
}
