<?php


namespace plugins\PageBuilder\Addons\Testimonial;

use App\Models\Feedback;
use plugins\PageBuilder\Fields\ColorPicker;
use plugins\PageBuilder\Fields\Image;
use plugins\PageBuilder\Fields\Number;
use plugins\PageBuilder\Fields\Slider;
use plugins\PageBuilder\Fields\Text;
use plugins\PageBuilder\Fields\Select;
use plugins\PageBuilder\PageBuilderBase;
use plugins\PageBuilder\Traits\LanguageFallbackForPageBuilder;

class TestimonialOne extends PageBuilderBase
{
    use LanguageFallbackForPageBuilder;

    public function preview_image()
    {
        return 'home-page/testimonial-1.png';
    }

    public function admin_render()
    {
        $output = $this->admin_form_before();
        $output .= $this->admin_form_start();
        $output .= $this->default_fields();
        $widget_saved_values = $this->get_settings();


        $output .= Text::get([
            'name' => 'title',
            'label' => __('Title'),
            'value' => $widget_saved_values['title'] ?? null,
        ]);
        $output .= Text::get([
            'name' => 'slider_button_text',
            'label' => __('Subtitle'),
            'value' => $widget_saved_values['slider_button_text'] ?? null,
        ]);
        $output .= Number::get([
            'name' => 'items',
            'label' => __('Items'),
            'value' => $widget_saved_values['items'] ?? null,
            'info' => __('enter how many item you want to show in frontend'),
        ]);
        $output .= Slider::get([
            'name' => 'padding_top',
            'label' => __('Padding Top'),
            'value' => $widget_saved_values['padding_top'] ?? 260,
            'max' => 500,
        ]);
        $output .= Slider::get([
            'name' => 'padding_bottom',
            'label' => __('Padding Bottom'),
            'value' => $widget_saved_values['padding_bottom'] ?? 190,
            'max' => 500,
        ]);
        $output .= ColorPicker::get([
            'name' => 'section_bg',
            'label' => __('Background Color'),
            'value' => $widget_saved_values['section_bg'] ?? null,
            'info' => __('select color you want to show in frontend'),
        ]);

        $output .= Image::get([
            'name' => 'testimonial_image',
            'label' => __('Testimonial Image'),
            'value' => $widget_saved_values['testimonial_image'] ?? null,
            'info' => __('recommended size is width: 546px and height: 596px'),
        ]);

        $output .= $this->admin_form_submit_button();
        $output .= $this->admin_form_end();
        $output .= $this->admin_form_after();

        return $output;
    }


    public function frontend_render()
    {
        $settings = $this->get_settings();
        $title =$settings['title'];
        $slider_button_text =$settings['slider_button_text'] ?? null;
        $items =$settings['items'] ?? 10;
        $padding_top =$settings['padding_top'];
        $padding_bottom =$settings['padding_bottom'];
        $section_bg =$settings['section_bg'];
        $testimonial_image =$settings['testimonial_image'] ?? null;

        $feedbacks = Feedback::where('status',1)->whereHas('user')->take($items)->get();

        return $this->renderBlade('testimonial.testimonial-one',compact(['title','slider_button_text','padding_top','padding_bottom','section_bg','feedbacks','items','testimonial_image']));
    }

    public function addon_title()
    {
        return __('Testimonial: 01');
    }
}
