<?php //0113921e026919a7e8a751034d298670
/** @noinspection all */

namespace App\Events {

    use Illuminate\Broadcasting\PendingBroadcast;
    
    /**
     * @method static void dispatch($message, $admin_id = 1)
     * @method static PendingBroadcast broadcast($message, $admin_id = 1)
     */
    class AdminEvent {}
    
    /**
     * @method static void dispatch($message, $user_id)
     * @method static PendingBroadcast broadcast($message, $user_id)
     */
    class UserNotificationEvent {}
}

namespace App\Jobs {

    use Illuminate\Foundation\Bus\PendingDispatch;
    use Illuminate\Support\Fluent;
    
    /**
     * @method static PendingDispatch dispatch($email, $message)
     * @method static PendingDispatch|Fluent dispatchIf(boolean $bool, $email, $message)
     * @method static PendingDispatch|Fluent dispatchUnless(boolean $bool, $email, $message)
     * @method static mixed dispatchSync($email, $message)
     * @method static void dispatchAfterResponse($email, $message)
     */
    class SendEmailJob {}
    
    /**
     * @method static PendingDispatch dispatch($file, $type)
     * @method static PendingDispatch|Fluent dispatchIf(boolean $bool, $file, $type)
     * @method static PendingDispatch|Fluent dispatchUnless(boolean $bool, $file, $type)
     * @method static mixed dispatchSync($file, $type)
     * @method static void dispatchAfterResponse($file, $type)
     */
    class SyncLocalFileWithCloud {}
}

namespace Illuminate\Broadcasting {
    
    /**
     * @method static void dispatch(array|Channel|string $channels)
     * @method static PendingBroadcast broadcast(array|Channel|string $channels)
     */
    class AnonymousEvent {}
}

namespace Illuminate\Bus {

    use Illuminate\Foundation\Bus\PendingDispatch;
    use Illuminate\Support\Fluent;
    
    /**
     * @method static PendingDispatch dispatch(PendingBatch $batch)
     * @method static PendingDispatch|Fluent dispatchIf(boolean $bool, PendingBatch $batch)
     * @method static PendingDispatch|Fluent dispatchUnless(boolean $bool, PendingBatch $batch)
     * @method static mixed dispatchSync(PendingBatch $batch)
     * @method static void dispatchAfterResponse(PendingBatch $batch)
     */
    class ChainedBatch {}
}

namespace Illuminate\Foundation\Console {

    use Illuminate\Foundation\Bus\PendingDispatch;
    use Illuminate\Support\Fluent;
    
    /**
     * @method static PendingDispatch dispatch(array $data)
     * @method static PendingDispatch|Fluent dispatchIf(boolean $bool, array $data)
     * @method static PendingDispatch|Fluent dispatchUnless(boolean $bool, array $data)
     * @method static mixed dispatchSync(array $data)
     * @method static void dispatchAfterResponse(array $data)
     */
    class QueuedCommand {}
}

namespace Illuminate\Foundation\Events {

    use Illuminate\Broadcasting\PendingBroadcast;
    
    /**
     * @method static void dispatch(array $stubs)
     * @method static PendingBroadcast broadcast(array $stubs)
     */
    class PublishingStubs {}
}

namespace Illuminate\Queue {

    use Illuminate\Foundation\Bus\PendingDispatch;
    use Illuminate\Support\Fluent;
    use Laravel\SerializableClosure\SerializableClosure;
    
    /**
     * @method static PendingDispatch dispatch(SerializableClosure $closure)
     * @method static PendingDispatch|Fluent dispatchIf(boolean $bool, SerializableClosure $closure)
     * @method static PendingDispatch|Fluent dispatchUnless(boolean $bool, SerializableClosure $closure)
     * @method static mixed dispatchSync(SerializableClosure $closure)
     * @method static void dispatchAfterResponse(SerializableClosure $closure)
     */
    class CallQueuedClosure {}
}

namespace Modules\Chat\Events {

    use Illuminate\Broadcasting\PendingBroadcast;
    
    /**
     * @method static void dispatch(string $messageBlade, $message, $livechat, $client_id, $freelancer_id)
     * @method static PendingBroadcast broadcast(string $messageBlade, $message, $livechat, $client_id, $freelancer_id)
     */
    class LivechatUserMessageEvent {}
    
    /**
     * @method static void dispatch(string $messageBlade, $message, $livechat, $client_id, $freelancer_id)
     * @method static PendingBroadcast broadcast(string $messageBlade, $message, $livechat, $client_id, $freelancer_id)
     */
    class LivechatVendorMessageEvent {}
    
    /**
     * @method static void dispatch($message)
     * @method static PendingBroadcast broadcast($message)
     */
    class Message {}
}

namespace PragmaRX\Google2FALaravel\Events {

    use Illuminate\Broadcasting\PendingBroadcast;
    
    /**
     * @method static void dispatch($user)
     * @method static PendingBroadcast broadcast($user)
     */
    class LoggedOut {}
    
    /**
     * @method static void dispatch($user)
     * @method static PendingBroadcast broadcast($user)
     */
    class LoginFailed {}
    
    /**
     * @method static void dispatch($user)
     * @method static PendingBroadcast broadcast($user)
     */
    class LoginSucceeded {}
    
    /**
     * @method static void dispatch($user)
     * @method static PendingBroadcast broadcast($user)
     */
    class OneTimePasswordExpired {}
    
    /**
     * @method static void dispatch($user)
     * @method static PendingBroadcast broadcast($user)
     */
    class OneTimePasswordRequested {}
    
    /**
     * @method static void dispatch($user)
     * @method static PendingBroadcast broadcast($user)
     */
    class OneTimePasswordRequested53 {}
}

namespace Spatie\Permission\Events {

    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Foundation\Bus\PendingDispatch;
    use Illuminate\Support\Collection;
    use Illuminate\Support\Fluent;
    use Spatie\Permission\Contracts\Permission;
    use Spatie\Permission\Contracts\Role;
    
    /**
     * @method static PendingDispatch dispatch(Model $model, array|Collection|int[]|Permission|Permission[]|string[] $permissionsOrIds)
     * @method static PendingDispatch|Fluent dispatchIf(boolean $bool, Model $model, array|Collection|int[]|Permission|Permission[]|string[] $permissionsOrIds)
     * @method static PendingDispatch|Fluent dispatchUnless(boolean $bool, Model $model, array|Collection|int[]|Permission|Permission[]|string[] $permissionsOrIds)
     * @method static mixed dispatchSync(Model $model, array|Collection|int[]|Permission|Permission[]|string[] $permissionsOrIds)
     * @method static void dispatchAfterResponse(Model $model, array|Collection|int[]|Permission|Permission[]|string[] $permissionsOrIds)
     */
    class PermissionAttached {}
    
    /**
     * @method static PendingDispatch dispatch(Model $model, array|Collection|int[]|Permission|Permission[]|string[] $permissionsOrIds)
     * @method static PendingDispatch|Fluent dispatchIf(boolean $bool, Model $model, array|Collection|int[]|Permission|Permission[]|string[] $permissionsOrIds)
     * @method static PendingDispatch|Fluent dispatchUnless(boolean $bool, Model $model, array|Collection|int[]|Permission|Permission[]|string[] $permissionsOrIds)
     * @method static mixed dispatchSync(Model $model, array|Collection|int[]|Permission|Permission[]|string[] $permissionsOrIds)
     * @method static void dispatchAfterResponse(Model $model, array|Collection|int[]|Permission|Permission[]|string[] $permissionsOrIds)
     */
    class PermissionDetached {}
    
    /**
     * @method static PendingDispatch dispatch(Model $model, array|Collection|int[]|Role|Role[]|string[] $rolesOrIds)
     * @method static PendingDispatch|Fluent dispatchIf(boolean $bool, Model $model, array|Collection|int[]|Role|Role[]|string[] $rolesOrIds)
     * @method static PendingDispatch|Fluent dispatchUnless(boolean $bool, Model $model, array|Collection|int[]|Role|Role[]|string[] $rolesOrIds)
     * @method static mixed dispatchSync(Model $model, array|Collection|int[]|Role|Role[]|string[] $rolesOrIds)
     * @method static void dispatchAfterResponse(Model $model, array|Collection|int[]|Role|Role[]|string[] $rolesOrIds)
     */
    class RoleAttached {}
    
    /**
     * @method static PendingDispatch dispatch(Model $model, array|Collection|int[]|Role|Role[]|string[] $rolesOrIds)
     * @method static PendingDispatch|Fluent dispatchIf(boolean $bool, Model $model, array|Collection|int[]|Role|Role[]|string[] $rolesOrIds)
     * @method static PendingDispatch|Fluent dispatchUnless(boolean $bool, Model $model, array|Collection|int[]|Role|Role[]|string[] $rolesOrIds)
     * @method static mixed dispatchSync(Model $model, array|Collection|int[]|Role|Role[]|string[] $rolesOrIds)
     * @method static void dispatchAfterResponse(Model $model, array|Collection|int[]|Role|Role[]|string[] $rolesOrIds)
     */
    class RoleDetached {}
}
