<?php //bb54c694a6693768ac37a554601dd811
/** @noinspection all */

namespace App\Models {

    use Database\Factories\UserFactory;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasManyThrough;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Database\Eloquent\Relations\HasOneThrough;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Notifications\DatabaseNotificationCollection;
    use Illuminate\Support\Carbon;
    use Laravel\Sanctum\PersonalAccessToken;
    use LaravelIdea\Helper\App\Models\_IH_AdminNotification_C;
    use LaravelIdea\Helper\App\Models\_IH_AdminNotification_QB;
    use LaravelIdea\Helper\App\Models\_IH_Admin_C;
    use LaravelIdea\Helper\App\Models\_IH_Admin_QB;
    use LaravelIdea\Helper\App\Models\_IH_Bookmark_C;
    use LaravelIdea\Helper\App\Models\_IH_Bookmark_QB;
    use LaravelIdea\Helper\App\Models\_IH_CategoryUser_C;
    use LaravelIdea\Helper\App\Models\_IH_CategoryUser_QB;
    use LaravelIdea\Helper\App\Models\_IH_ClientNotification_C;
    use LaravelIdea\Helper\App\Models\_IH_ClientNotification_QB;
    use LaravelIdea\Helper\App\Models\_IH_ExperienceLevel_C;
    use LaravelIdea\Helper\App\Models\_IH_ExperienceLevel_QB;
    use LaravelIdea\Helper\App\Models\_IH_Feedback_C;
    use LaravelIdea\Helper\App\Models\_IH_Feedback_QB;
    use LaravelIdea\Helper\App\Models\_IH_FormBuilder_C;
    use LaravelIdea\Helper\App\Models\_IH_FormBuilder_QB;
    use LaravelIdea\Helper\App\Models\_IH_FreelancerNotification_C;
    use LaravelIdea\Helper\App\Models\_IH_FreelancerNotification_QB;
    use LaravelIdea\Helper\App\Models\_IH_IdentityVerification_C;
    use LaravelIdea\Helper\App\Models\_IH_IdentityVerification_QB;
    use LaravelIdea\Helper\App\Models\_IH_IndividualCommissionSetting_C;
    use LaravelIdea\Helper\App\Models\_IH_IndividualCommissionSetting_QB;
    use LaravelIdea\Helper\App\Models\_IH_JobHistory_C;
    use LaravelIdea\Helper\App\Models\_IH_JobHistory_QB;
    use LaravelIdea\Helper\App\Models\_IH_JobPostSkill_C;
    use LaravelIdea\Helper\App\Models\_IH_JobPostSkill_QB;
    use LaravelIdea\Helper\App\Models\_IH_JobPostSubCategory_C;
    use LaravelIdea\Helper\App\Models\_IH_JobPostSubCategory_QB;
    use LaravelIdea\Helper\App\Models\_IH_JobPost_C;
    use LaravelIdea\Helper\App\Models\_IH_JobPost_QB;
    use LaravelIdea\Helper\App\Models\_IH_JobProposal_C;
    use LaravelIdea\Helper\App\Models\_IH_JobProposal_QB;
    use LaravelIdea\Helper\App\Models\_IH_JobSkill_C;
    use LaravelIdea\Helper\App\Models\_IH_JobSkill_QB;
    use LaravelIdea\Helper\App\Models\_IH_JobSubCategory_C;
    use LaravelIdea\Helper\App\Models\_IH_JobSubCategory_QB;
    use LaravelIdea\Helper\App\Models\_IH_Language_C;
    use LaravelIdea\Helper\App\Models\_IH_Language_QB;
    use LaravelIdea\Helper\App\Models\_IH_Length_C;
    use LaravelIdea\Helper\App\Models\_IH_Length_QB;
    use LaravelIdea\Helper\App\Models\_IH_MediaUpload_C;
    use LaravelIdea\Helper\App\Models\_IH_MediaUpload_QB;
    use LaravelIdea\Helper\App\Models\_IH_Menu_C;
    use LaravelIdea\Helper\App\Models\_IH_Menu_QB;
    use LaravelIdea\Helper\App\Models\_IH_NewsLetterForEmail_C;
    use LaravelIdea\Helper\App\Models\_IH_NewsLetterForEmail_QB;
    use LaravelIdea\Helper\App\Models\_IH_OrderDeclineHistory_C;
    use LaravelIdea\Helper\App\Models\_IH_OrderDeclineHistory_QB;
    use LaravelIdea\Helper\App\Models\_IH_OrderDeclineWalletHistory_C;
    use LaravelIdea\Helper\App\Models\_IH_OrderDeclineWalletHistory_QB;
    use LaravelIdea\Helper\App\Models\_IH_OrderMilestone_C;
    use LaravelIdea\Helper\App\Models\_IH_OrderMilestone_QB;
    use LaravelIdea\Helper\App\Models\_IH_OrderRequestRevision_C;
    use LaravelIdea\Helper\App\Models\_IH_OrderRequestRevision_QB;
    use LaravelIdea\Helper\App\Models\_IH_OrderScreenshot_C;
    use LaravelIdea\Helper\App\Models\_IH_OrderScreenshot_QB;
    use LaravelIdea\Helper\App\Models\_IH_OrderSubmitHistory_C;
    use LaravelIdea\Helper\App\Models\_IH_OrderSubmitHistory_QB;
    use LaravelIdea\Helper\App\Models\_IH_OrderWorkHistory_C;
    use LaravelIdea\Helper\App\Models\_IH_OrderWorkHistory_QB;
    use LaravelIdea\Helper\App\Models\_IH_Order_C;
    use LaravelIdea\Helper\App\Models\_IH_Order_QB;
    use LaravelIdea\Helper\App\Models\_IH_PageBuilder_C;
    use LaravelIdea\Helper\App\Models\_IH_PageBuilder_QB;
    use LaravelIdea\Helper\App\Models\_IH_Portfolio_C;
    use LaravelIdea\Helper\App\Models\_IH_Portfolio_QB;
    use LaravelIdea\Helper\App\Models\_IH_ProjectAttribute_C;
    use LaravelIdea\Helper\App\Models\_IH_ProjectAttribute_QB;
    use LaravelIdea\Helper\App\Models\_IH_ProjectHistory_C;
    use LaravelIdea\Helper\App\Models\_IH_ProjectHistory_QB;
    use LaravelIdea\Helper\App\Models\_IH_ProjectIntroduction_C;
    use LaravelIdea\Helper\App\Models\_IH_ProjectIntroduction_QB;
    use LaravelIdea\Helper\App\Models\_IH_ProjectSubCategory_C;
    use LaravelIdea\Helper\App\Models\_IH_ProjectSubCategory_QB;
    use LaravelIdea\Helper\App\Models\_IH_Project_C;
    use LaravelIdea\Helper\App\Models\_IH_Project_QB;
    use LaravelIdea\Helper\App\Models\_IH_RatingDetails_C;
    use LaravelIdea\Helper\App\Models\_IH_RatingDetails_QB;
    use LaravelIdea\Helper\App\Models\_IH_Rating_C;
    use LaravelIdea\Helper\App\Models\_IH_Rating_QB;
    use LaravelIdea\Helper\App\Models\_IH_Report_C;
    use LaravelIdea\Helper\App\Models\_IH_Report_QB;
    use LaravelIdea\Helper\App\Models\_IH_Skill_C;
    use LaravelIdea\Helper\App\Models\_IH_Skill_QB;
    use LaravelIdea\Helper\App\Models\_IH_SocialProfile_C;
    use LaravelIdea\Helper\App\Models\_IH_SocialProfile_QB;
    use LaravelIdea\Helper\App\Models\_IH_StaticOption_C;
    use LaravelIdea\Helper\App\Models\_IH_StaticOption_QB;
    use LaravelIdea\Helper\App\Models\_IH_SubCategoryUser_C;
    use LaravelIdea\Helper\App\Models\_IH_SubCategoryUser_QB;
    use LaravelIdea\Helper\App\Models\_IH_UserEarning_C;
    use LaravelIdea\Helper\App\Models\_IH_UserEarning_QB;
    use LaravelIdea\Helper\App\Models\_IH_UserEducation_C;
    use LaravelIdea\Helper\App\Models\_IH_UserEducation_QB;
    use LaravelIdea\Helper\App\Models\_IH_UserExperience_C;
    use LaravelIdea\Helper\App\Models\_IH_UserExperience_QB;
    use LaravelIdea\Helper\App\Models\_IH_UserIntroduction_C;
    use LaravelIdea\Helper\App\Models\_IH_UserIntroduction_QB;
    use LaravelIdea\Helper\App\Models\_IH_UserLang_C;
    use LaravelIdea\Helper\App\Models\_IH_UserLang_QB;
    use LaravelIdea\Helper\App\Models\_IH_UserNotification_C;
    use LaravelIdea\Helper\App\Models\_IH_UserNotification_QB;
    use LaravelIdea\Helper\App\Models\_IH_UserSkill_C;
    use LaravelIdea\Helper\App\Models\_IH_UserSkill_QB;
    use LaravelIdea\Helper\App\Models\_IH_UserWork_C;
    use LaravelIdea\Helper\App\Models\_IH_UserWork_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_C;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\App\Models\_IH_Widget_C;
    use LaravelIdea\Helper\App\Models\_IH_Widget_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_C;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_QB;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_LiveChatMessage_C;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_LiveChatMessage_QB;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_LiveChat_QB;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_City_QB;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_Country_QB;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_State_QB;
    use LaravelIdea\Helper\Modules\Credit\App\Models\_IH_Credit_C;
    use LaravelIdea\Helper\Modules\Credit\App\Models\_IH_Credit_QB;
    use LaravelIdea\Helper\Modules\Credit\App\Models\_IH_UserCredit_QB;
    use LaravelIdea\Helper\Modules\Pages\Entities\_IH_MetaData_QB;
    use LaravelIdea\Helper\Modules\Service\Entities\_IH_Category_C;
    use LaravelIdea\Helper\Modules\Service\Entities\_IH_Category_QB;
    use LaravelIdea\Helper\Modules\Service\Entities\_IH_SubCategory_C;
    use LaravelIdea\Helper\Modules\Service\Entities\_IH_SubCategory_QB;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_Wallet_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_QB;
    use Modules\Chat\Entities\LiveChat;
    use Modules\Chat\Entities\LiveChatMessage;
    use Modules\CountryManage\Entities\City;
    use Modules\CountryManage\Entities\Country;
    use Modules\CountryManage\Entities\State;
    use Modules\Credit\App\Models\Credit;
    use Modules\Credit\App\Models\UserCredit;
    use Modules\Pages\Entities\MetaData;
    use Modules\Service\Entities\Category;
    use Modules\Service\Entities\SubCategory;
    use Modules\Wallet\Entities\Wallet;
    use Spatie\Permission\Models\Permission;
    use Spatie\Permission\Models\Role;
    
    /**
     * @property int $id
     * @property string $name
     * @property string $username
     * @property string $email
     * @property int $is_email_verified 0: not verified, 1:verified
     * @property string|null $phone
     * @property string $role
     * @property string|null $image
     * @property string $password
     * @property int $status 0:active, 1:inactive
     * @property string|null $designation
     * @property string|null $about
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $email_verify_token
     * @property _IH_Permission_C|Permission[] $permissions
     * @property-read int $permissions_count
     * @method MorphToMany|_IH_Permission_QB permissions()
     * @property _IH_Role_C|Role[] $roles
     * @property-read int $roles_count
     * @method MorphToMany|_IH_Role_QB roles()
     * @method static _IH_Admin_QB onWriteConnection()
     * @method _IH_Admin_QB newQuery()
     * @method static _IH_Admin_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Admin_QB query()
     * @method static _IH_Admin_QB with(array|string $relations)
     * @method _IH_Admin_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Admin_C|Admin[] all($columns = ['*'])
     * @foreignLinks id,\Modules\Chat\Entities\LiveChat,admin_id|id,\Modules\SupportTicket\Entities\Ticket,admin_id|id,\Modules\Blog\Entities\BlogPost,admin_id
     * @mixin _IH_Admin_QB
     */
    class Admin extends Model {}
    
    /**
     * @property int $id
     * @property int $identity
     * @property int $user_id
     * @property string|null $type
     * @property string $message
     * @property string $is_read
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property JobPost $job
     * @method BelongsTo|_IH_JobPost_QB job()
     * @property Project $project
     * @method BelongsTo|_IH_Project_QB project()
     * @method static _IH_AdminNotification_QB onWriteConnection()
     * @method _IH_AdminNotification_QB newQuery()
     * @method static _IH_AdminNotification_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_AdminNotification_QB query()
     * @method static _IH_AdminNotification_QB with(array|string $relations)
     * @method _IH_AdminNotification_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AdminNotification_C|AdminNotification[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_AdminNotification_QB
     */
    class AdminNotification extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $identity
     * @property string $is_project_job
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property JobPost $bookmark_job
     * @method BelongsTo|_IH_JobPost_QB bookmark_job()
     * @property Project $bookmark_project
     * @method BelongsTo|_IH_Project_QB bookmark_project()
     * @method static _IH_Bookmark_QB onWriteConnection()
     * @method _IH_Bookmark_QB newQuery()
     * @method static _IH_Bookmark_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Bookmark_QB query()
     * @method static _IH_Bookmark_QB with(array|string $relations)
     * @method _IH_Bookmark_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Bookmark_C|Bookmark[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_Bookmark_QB
     */
    class Bookmark extends Model {}
    
    /**
     * @property int $id
     * @property int $category_id
     * @property int $user_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Category $category
     * @method BelongsTo|_IH_Category_QB category()
     * @method static _IH_CategoryUser_QB onWriteConnection()
     * @method _IH_CategoryUser_QB newQuery()
     * @method static _IH_CategoryUser_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_CategoryUser_QB query()
     * @method static _IH_CategoryUser_QB with(array|string $relations)
     * @method _IH_CategoryUser_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CategoryUser_C|CategoryUser[] all($columns = ['*'])
     * @ownLinks category_id,\Modules\Service\Entities\Category,id|user_id,\App\Models\User,id
     * @mixin _IH_CategoryUser_QB
     */
    class CategoryUser extends Model {}
    
    /**
     * @property int $id
     * @property int $identity
     * @property int $client_id
     * @property string $type
     * @property string $message
     * @property string $is_read
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_ClientNotification_QB onWriteConnection()
     * @method _IH_ClientNotification_QB newQuery()
     * @method static _IH_ClientNotification_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_ClientNotification_QB query()
     * @method static _IH_ClientNotification_QB with(array|string $relations)
     * @method _IH_ClientNotification_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ClientNotification_C|ClientNotification[] all($columns = ['*'])
     * @mixin _IH_ClientNotification_QB
     */
    class ClientNotification extends Model {}
    
    /**
     * @property int $id
     * @property string $level
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_ExperienceLevel_QB onWriteConnection()
     * @method _IH_ExperienceLevel_QB newQuery()
     * @method static _IH_ExperienceLevel_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_ExperienceLevel_QB query()
     * @method static _IH_ExperienceLevel_QB with(array|string $relations)
     * @method _IH_ExperienceLevel_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ExperienceLevel_C|ExperienceLevel[] all($columns = ['*'])
     * @mixin _IH_ExperienceLevel_QB
     */
    class ExperienceLevel extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $title
     * @property string $description
     * @property int $rating
     * @property int $status 0=active 1=inactive
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Feedback_QB onWriteConnection()
     * @method _IH_Feedback_QB newQuery()
     * @method static _IH_Feedback_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Feedback_QB query()
     * @method static _IH_Feedback_QB with(array|string $relations)
     * @method _IH_Feedback_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Feedback_C|Feedback[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_Feedback_QB
     */
    class Feedback extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property string|null $email
     * @property string|null $button_text
     * @property string|null $fields
     * @property string|null $success_message
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_FormBuilder_QB onWriteConnection()
     * @method _IH_FormBuilder_QB newQuery()
     * @method static _IH_FormBuilder_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_FormBuilder_QB query()
     * @method static _IH_FormBuilder_QB with(array|string $relations)
     * @method _IH_FormBuilder_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_FormBuilder_C|FormBuilder[] all($columns = ['*'])
     * @mixin _IH_FormBuilder_QB
     */
    class FormBuilder extends Model {}
    
    /**
     * @property int $id
     * @property int $identity
     * @property int $freelancer_id
     * @property string $type
     * @property string $message
     * @property string $is_read
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_FreelancerNotification_QB onWriteConnection()
     * @method _IH_FreelancerNotification_QB newQuery()
     * @method static _IH_FreelancerNotification_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_FreelancerNotification_QB query()
     * @method static _IH_FreelancerNotification_QB with(array|string $relations)
     * @method _IH_FreelancerNotification_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_FreelancerNotification_C|FreelancerNotification[] all($columns = ['*'])
     * @mixin _IH_FreelancerNotification_QB
     */
    class FreelancerNotification extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $verify_by
     * @property int $country_id
     * @property int $state_id
     * @property int $city_id
     * @property string $address
     * @property string $zipcode
     * @property string $national_id_number
     * @property string $front_image
     * @property string $back_image
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $status 1=verified, 2=rejected
     * @property int $is_read 1=read and 0=unread
     * @property int $load_from
     * @property int $is_synced
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @property City $user_city
     * @method BelongsTo|_IH_City_QB user_city()
     * @property Country $user_country
     * @method BelongsTo|_IH_Country_QB user_country()
     * @property State $user_state
     * @method BelongsTo|_IH_State_QB user_state()
     * @method static _IH_IdentityVerification_QB onWriteConnection()
     * @method _IH_IdentityVerification_QB newQuery()
     * @method static _IH_IdentityVerification_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_IdentityVerification_QB query()
     * @method static _IH_IdentityVerification_QB with(array|string $relations)
     * @method _IH_IdentityVerification_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_IdentityVerification_C|IdentityVerification[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id|country_id,\Modules\CountryManage\Entities\Country,id|state_id,\Modules\CountryManage\Entities\State,id|city_id,\Modules\CountryManage\Entities\City,id
     * @mixin _IH_IdentityVerification_QB
     */
    class IdentityVerification extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $admin_commission_type
     * @property float $admin_commission_charge
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_IndividualCommissionSetting_QB onWriteConnection()
     * @method _IH_IndividualCommissionSetting_QB newQuery()
     * @method static _IH_IndividualCommissionSetting_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_IndividualCommissionSetting_QB query()
     * @method static _IH_IndividualCommissionSetting_QB with(array|string $relations)
     * @method _IH_IndividualCommissionSetting_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_IndividualCommissionSetting_C|IndividualCommissionSetting[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_IndividualCommissionSetting_QB
     */
    class IndividualCommissionSetting extends Model {}
    
    /**
     * @property int $id
     * @property int $job_id
     * @property int $user_id
     * @property int|null $reject_count
     * @property int|null $edit_count
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property JobPost $job
     * @method HasOne|_IH_JobPost_QB job()
     * @method static _IH_JobHistory_QB onWriteConnection()
     * @method _IH_JobHistory_QB newQuery()
     * @method static _IH_JobHistory_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_JobHistory_QB query()
     * @method static _IH_JobHistory_QB with(array|string $relations)
     * @method _IH_JobHistory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_JobHistory_C|JobHistory[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_JobHistory_QB
     */
    class JobHistory extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $title
     * @property string $slug
     * @property int $category
     * @property string $duration
     * @property string|null $level
     * @property string $description
     * @property string $type
     * @property float $budget
     * @property string $attachment
     * @property int $status 0=pending, 1=approve
     * @property int $on_off 1=on, 0=off
     * @property int $job_approve_request 0=request for approve, 1=approve, 2=decline, 2=will change to 0 when the user edit the project.
     * @property Carbon|null $last_seen
     * @property Carbon|null $last_apply_date
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $current_status 0=nothing, 1=in progress, 2=complete, 3=cancel
     * @property string|null $meta_title
     * @property string|null $meta_description
     * @property string|null $meta_tags
     * @property int $load_from
     * @property int $is_synced
     * @property int|null $hourly_rate
     * @property int|null $estimated_hours
     * @property int|null $min_followers
     * @property Category $job_category
     * @method BelongsTo|_IH_Category_QB job_category()
     * @property User $job_creator
     * @method BelongsTo|_IH_User_QB job_creator()
     * @property JobHistory $job_history
     * @method HasOne|_IH_JobHistory_QB job_history()
     * @property _IH_JobProposal_C|JobProposal[] $job_proposals
     * @property-read int $job_proposals_count
     * @method HasMany|_IH_JobProposal_QB job_proposals()
     * @property _IH_Skill_C|Skill[] $job_skills
     * @property-read int $job_skills_count
     * @method BelongsToMany|_IH_Skill_QB job_skills()
     * @property _IH_SubCategory_C|SubCategory[] $job_sub_categories
     * @property-read int $job_sub_categories_count
     * @method BelongsToMany|_IH_SubCategory_QB job_sub_categories()
     * @property MetaData $metaData
     * @method MorphToMany|_IH_MetaData_QB metaData()
     * @method static _IH_JobPost_QB onWriteConnection()
     * @method _IH_JobPost_QB newQuery()
     * @method static _IH_JobPost_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_JobPost_QB query()
     * @method static _IH_JobPost_QB with(array|string $relations)
     * @method _IH_JobPost_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_JobPost_C|JobPost[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @foreignLinks id,\App\Models\JobSkill,job_post_id|id,\App\Models\JobPostSubCategory,job_post_id|id,\App\Models\JobPostSkill,job_post_id
     * @mixin _IH_JobPost_QB
     */
    class JobPost extends Model {}
    
    /**
     * @property int $id
     * @property int $job_post_id
     * @property int $skill_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_JobPostSkill_QB onWriteConnection()
     * @method _IH_JobPostSkill_QB newQuery()
     * @method static _IH_JobPostSkill_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_JobPostSkill_QB query()
     * @method static _IH_JobPostSkill_QB with(array|string $relations)
     * @method _IH_JobPostSkill_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_JobPostSkill_C|JobPostSkill[] all($columns = ['*'])
     * @ownLinks job_post_id,\App\Models\JobPost,id|skill_id,\App\Models\Skill,id
     * @mixin _IH_JobPostSkill_QB
     */
    class JobPostSkill extends Model {}
    
    /**
     * @property int $id
     * @property int $job_post_id
     * @property int $sub_category_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_JobPostSubCategory_QB onWriteConnection()
     * @method _IH_JobPostSubCategory_QB newQuery()
     * @method static _IH_JobPostSubCategory_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_JobPostSubCategory_QB query()
     * @method static _IH_JobPostSubCategory_QB with(array|string $relations)
     * @method _IH_JobPostSubCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_JobPostSubCategory_C|JobPostSubCategory[] all($columns = ['*'])
     * @ownLinks job_post_id,\App\Models\JobPost,id|sub_category_id,\Modules\Service\Entities\SubCategory,id
     * @mixin _IH_JobPostSubCategory_QB
     */
    class JobPostSubCategory extends Model {}
    
    /**
     * @property int $id
     * @property int $job_id
     * @property int $freelancer_id
     * @property int $client_id
     * @property float $amount
     * @property string $duration
     * @property string $cover_letter
     * @property string|null $attachment
     * @property int $status 0=pending, 1=accept, 2=reject
     * @property int $is_hired 0=no, 1=yes
     * @property int $is_short_listed 0=no, 1=yes
     * @property int $is_interview_take 0=no, 1=yes
     * @property int $is_view 0=no, 1=yes
     * @property int $is_rejected 0=no, 1=yes
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $revision
     * @property int $load_from
     * @property int $is_synced
     * @property _IH_Order_C|Order[] $complete_order_count_api
     * @property-read int $complete_order_count_api_count
     * @method HasMany|_IH_Order_QB complete_order_count_api()
     * @property User $freelancer
     * @method BelongsTo|_IH_User_QB freelancer()
     * @property Country $freelancer_country_for_api
     * @method HasOneThrough|_IH_Country_QB freelancer_country_for_api()
     * @property UserIntroduction $freelancer_introduction_title_for_api
     * @method HasOneThrough|_IH_UserIntroduction_QB freelancer_introduction_title_for_api()
     * @property _IH_Rating_C|Rating[] $freelancer_ratings
     * @property-read int $freelancer_ratings_count
     * @method HasManyThrough|_IH_Rating_QB freelancer_ratings()
     * @property State $freelancer_state_for_api
     * @method HasOneThrough|_IH_State_QB freelancer_state_for_api()
     * @property JobPost $job
     * @method BelongsTo|_IH_JobPost_QB job()
     * @property LiveChat $live_chat_for_api
     * @method BelongsTo|_IH_LiveChat_QB live_chat_for_api()
     * @method static _IH_JobProposal_QB onWriteConnection()
     * @method _IH_JobProposal_QB newQuery()
     * @method static _IH_JobProposal_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_JobProposal_QB query()
     * @method static _IH_JobProposal_QB with(array|string $relations)
     * @method _IH_JobProposal_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_JobProposal_C|JobProposal[] all($columns = ['*'])
     * @ownLinks 
     * @mixin _IH_JobProposal_QB
     */
    class JobProposal extends Model {}
    
    /**
     * @property int $id
     * @property int $job_post_id
     * @property int $skill_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_JobSkill_QB onWriteConnection()
     * @method _IH_JobSkill_QB newQuery()
     * @method static _IH_JobSkill_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_JobSkill_QB query()
     * @method static _IH_JobSkill_QB with(array|string $relations)
     * @method _IH_JobSkill_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_JobSkill_C|JobSkill[] all($columns = ['*'])
     * @ownLinks job_post_id,\App\Models\JobPost,id|skill_id,\App\Models\Skill,id
     * @mixin _IH_JobSkill_QB
     */
    class JobSkill extends Model {}
    
    /**
     * @method static _IH_JobSubCategory_QB onWriteConnection()
     * @method _IH_JobSubCategory_QB newQuery()
     * @method static _IH_JobSubCategory_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_JobSubCategory_QB query()
     * @method static _IH_JobSubCategory_QB with(array|string $relations)
     * @method _IH_JobSubCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_JobSubCategory_C|JobSubCategory[] all($columns = ['*'])
     * @mixin _IH_JobSubCategory_QB
     */
    class JobSubCategory extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $slug
     * @property string|null $direction
     * @property string|null $status
     * @property int|null $default
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Language_QB onWriteConnection()
     * @method _IH_Language_QB newQuery()
     * @method static _IH_Language_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Language_QB query()
     * @method static _IH_Language_QB with(array|string $relations)
     * @method _IH_Language_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Language_C|Language[] all($columns = ['*'])
     * @mixin _IH_Language_QB
     */
    class Language extends Model {}
    
    /**
     * @property int $id
     * @property string $length
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Length_QB onWriteConnection()
     * @method _IH_Length_QB newQuery()
     * @method static _IH_Length_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Length_QB query()
     * @method static _IH_Length_QB with(array|string $relations)
     * @method _IH_Length_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Length_C|Length[] all($columns = ['*'])
     * @mixin _IH_Length_QB
     */
    class Length extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string $path
     * @property string|null $alt
     * @property string|null $size
     * @property string|null $dimensions
     * @property string $type
     * @property int|null $user_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $load_from
     * @property int $is_synced
     * @method static _IH_MediaUpload_QB onWriteConnection()
     * @method _IH_MediaUpload_QB newQuery()
     * @method static _IH_MediaUpload_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_MediaUpload_QB query()
     * @method static _IH_MediaUpload_QB with(array|string $relations)
     * @method _IH_MediaUpload_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MediaUpload_C|MediaUpload[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_MediaUpload_QB
     */
    class MediaUpload extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string|null $content
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Menu_QB onWriteConnection()
     * @method _IH_Menu_QB newQuery()
     * @method static _IH_Menu_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Menu_QB query()
     * @method static _IH_Menu_QB with(array|string $relations)
     * @method _IH_Menu_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Menu_C|Menu[] all($columns = ['*'])
     * @mixin _IH_Menu_QB
     */
    class Menu extends Model {}
    
    /**
     * @property int $id
     * @property string $email
     * @property string|null $token
     * @property string|null $verified
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_NewsLetterForEmail_QB onWriteConnection()
     * @method _IH_NewsLetterForEmail_QB newQuery()
     * @method static _IH_NewsLetterForEmail_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_NewsLetterForEmail_QB query()
     * @method static _IH_NewsLetterForEmail_QB with(array|string $relations)
     * @method _IH_NewsLetterForEmail_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_NewsLetterForEmail_C|NewsLetterForEmail[] all($columns = ['*'])
     * @mixin _IH_NewsLetterForEmail_QB
     */
    class NewsLetterForEmail extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id client id
     * @property int $freelancer_id
     * @property int $identity project_id or job_id
     * @property string $is_project_job project or job
     * @property string|null $is_basic_standard_premium_custom project type
     * @property string|null $is_fixed_hourly fixed or hourly
     * @property int $is_custom 1=custom
     * @property int $status 0=pending, 1=active, 2=delivered, 3=complete, 4=cancel, 5=decline by frl, 6=suspend by ad, 7=hold by ad
     * @property string|null $revision
     * @property string|null $delivery_time
     * @property string|null $description
     * @property float $price
     * @property string $commission_type
     * @property float $commission_charge
     * @property float $commission_amount
     * @property string|null $transaction_type
     * @property float $transaction_charge
     * @property float $transaction_amount
     * @property float $payable_amount
     * @property float $refund_amount
     * @property int $refund_status 0=pending, 1=paid
     * @property float|null $total_hour
     * @property string $payment_gateway
     * @property string $payment_status
     * @property string|null $transaction_id
     * @property string|null $manual_payment_image
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $revision_left
     * @property int $status_before_hold 0=not hold , 1=hold
     * @property string|null $is_valid_payment
     * @property string|null $email_send
     * @property string|null $order_type
     * @property User $freelancer
     * @method BelongsTo|_IH_User_QB freelancer()
     * @property _IH_OrderWorkHistory_C|OrderWorkHistory[] $hourly_work_history
     * @property-read int $hourly_work_history_count
     * @method HasMany|_IH_OrderWorkHistory_QB hourly_work_history()
     * @property JobPost $job
     * @method BelongsTo|_IH_JobPost_QB job()
     * @property _IH_OrderMilestone_C|OrderMilestone[] $order_mile_stones
     * @property-read int $order_mile_stones_count
     * @method HasMany|_IH_OrderMilestone_QB order_mile_stones()
     * @property _IH_OrderRequestRevision_C|OrderRequestRevision[] $order_request_revision
     * @property-read int $order_request_revision_count
     * @method HasMany|_IH_OrderRequestRevision_QB order_request_revision()
     * @property _IH_OrderSubmitHistory_C|OrderSubmitHistory[] $order_submit_history
     * @property-read int $order_submit_history_count
     * @method HasMany|_IH_OrderSubmitHistory_QB order_submit_history()
     * @property Project $project
     * @method BelongsTo|_IH_Project_QB project()
     * @property _IH_Rating_C|Rating[] $rating
     * @property-read int $rating_count
     * @method HasMany|_IH_Rating_QB rating()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Order_QB onWriteConnection()
     * @method _IH_Order_QB newQuery()
     * @method static _IH_Order_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Order_QB query()
     * @method static _IH_Order_QB with(array|string $relations)
     * @method _IH_Order_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Order_C|Order[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @foreignLinks id,\App\Models\OrderMilestone,order_id|id,\App\Models\OrderDeclineHistory,order_id|id,\App\Models\OrderDeclineWalletHistory,order_id|id,\App\Models\OrderSubmitHistory,order_id|id,\App\Models\OrderRequestRevision,order_id|id,\App\Models\Rating,order_id|id,\App\Models\Report,order_id|id,\App\Models\OrderWorkHistory,order_id|id,\App\Models\OrderScreenshot,order_id
     * @mixin _IH_Order_QB
     */
    class Order extends Model {}
    
    /**
     * @property int $id
     * @property int $order_id
     * @property int $freelancer_id
     * @property int $client_id
     * @property float $order_price
     * @property string $payment_status
     * @property string|null $cancel_or_decline
     * @property string|null $cancel_by
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_OrderDeclineHistory_QB onWriteConnection()
     * @method _IH_OrderDeclineHistory_QB newQuery()
     * @method static _IH_OrderDeclineHistory_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_OrderDeclineHistory_QB query()
     * @method static _IH_OrderDeclineHistory_QB with(array|string $relations)
     * @method _IH_OrderDeclineHistory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OrderDeclineHistory_C|OrderDeclineHistory[] all($columns = ['*'])
     * @ownLinks order_id,\App\Models\Order,id
     * @mixin _IH_OrderDeclineHistory_QB
     */
    class OrderDeclineHistory extends Model {}
    
    /**
     * @property int $id
     * @property int $order_id
     * @property int $freelancer_id
     * @property int $client_id
     * @property float $order_price
     * @property string $payment_status
     * @property string|null $cancel_or_decline
     * @property string|null $cancel_by
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_OrderDeclineWalletHistory_QB onWriteConnection()
     * @method _IH_OrderDeclineWalletHistory_QB newQuery()
     * @method static _IH_OrderDeclineWalletHistory_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_OrderDeclineWalletHistory_QB query()
     * @method static _IH_OrderDeclineWalletHistory_QB with(array|string $relations)
     * @method _IH_OrderDeclineWalletHistory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OrderDeclineWalletHistory_C|OrderDeclineWalletHistory[] all($columns = ['*'])
     * @ownLinks order_id,\App\Models\Order,id
     * @mixin _IH_OrderDeclineWalletHistory_QB
     */
    class OrderDeclineWalletHistory extends Model {}
    
    /**
     * @property int $id
     * @property int $order_id
     * @property string $title
     * @property string $description
     * @property float $price
     * @property string $deadline
     * @property int $status 0=pending, 1=active, 2=complete, 3=cancel
     * @property int $revision
     * @property int $revision_left
     * @property string|null $attachment
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_OrderMilestone_QB onWriteConnection()
     * @method _IH_OrderMilestone_QB newQuery()
     * @method static _IH_OrderMilestone_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_OrderMilestone_QB query()
     * @method static _IH_OrderMilestone_QB with(array|string $relations)
     * @method _IH_OrderMilestone_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OrderMilestone_C|OrderMilestone[] all($columns = ['*'])
     * @ownLinks order_id,\App\Models\Order,id
     * @foreignLinks id,\App\Models\OrderSubmitHistory,order_milestone_id
     * @mixin _IH_OrderMilestone_QB
     */
    class OrderMilestone extends Model {}
    
    /**
     * @property int $id
     * @property int $order_id
     * @property int|null $order_submit_history_id
     * @property int|null $milestone_id
     * @property string|null $description
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_OrderRequestRevision_QB onWriteConnection()
     * @method _IH_OrderRequestRevision_QB newQuery()
     * @method static _IH_OrderRequestRevision_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_OrderRequestRevision_QB query()
     * @method static _IH_OrderRequestRevision_QB with(array|string $relations)
     * @method _IH_OrderRequestRevision_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OrderRequestRevision_C|OrderRequestRevision[] all($columns = ['*'])
     * @ownLinks order_id,\App\Models\Order,id|order_submit_history_id,\App\Models\OrderSubmitHistory,id
     * @mixin _IH_OrderRequestRevision_QB
     */
    class OrderRequestRevision extends Model {}
    
    /**
     * @property int $id
     * @property int $order_id
     * @property string $image
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_OrderScreenshot_QB onWriteConnection()
     * @method _IH_OrderScreenshot_QB newQuery()
     * @method static _IH_OrderScreenshot_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_OrderScreenshot_QB query()
     * @method static _IH_OrderScreenshot_QB with(array|string $relations)
     * @method _IH_OrderScreenshot_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OrderScreenshot_C|OrderScreenshot[] all($columns = ['*'])
     * @ownLinks order_id,\App\Models\Order,id
     * @mixin _IH_OrderScreenshot_QB
     */
    class OrderScreenshot extends Model {}
    
    /**
     * @property int $id
     * @property int $order_id
     * @property int|null $order_milestone_id
     * @property string $attachment
     * @property int $status 0=pending, 1=approve, 2=request revision,
     * @property string $description
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property OrderRequestRevision $request_revision
     * @method HasOne|_IH_OrderRequestRevision_QB request_revision()
     * @method static _IH_OrderSubmitHistory_QB onWriteConnection()
     * @method _IH_OrderSubmitHistory_QB newQuery()
     * @method static _IH_OrderSubmitHistory_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_OrderSubmitHistory_QB query()
     * @method static _IH_OrderSubmitHistory_QB with(array|string $relations)
     * @method _IH_OrderSubmitHistory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OrderSubmitHistory_C|OrderSubmitHistory[] all($columns = ['*'])
     * @ownLinks order_id,\App\Models\Order,id|order_milestone_id,\App\Models\OrderMilestone,id
     * @foreignLinks id,\App\Models\OrderRequestRevision,order_submit_history_id
     * @mixin _IH_OrderSubmitHistory_QB
     */
    class OrderSubmitHistory extends Model {}
    
    /**
     * @property int $id
     * @property int $order_id
     * @property int $client_id
     * @property int $freelancer_id
     * @property int|null $job_id
     * @property Carbon|null $start_date
     * @property Carbon|null $end_date
     * @property Carbon|null $only_start_date
     * @property Carbon|null $only_end_date
     * @property Carbon $hours_worked
     * @property int|null $seconds
     * @property string|null $notes
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Order $order
     * @method BelongsTo|_IH_Order_QB order()
     * @method static _IH_OrderWorkHistory_QB onWriteConnection()
     * @method _IH_OrderWorkHistory_QB newQuery()
     * @method static _IH_OrderWorkHistory_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_OrderWorkHistory_QB query()
     * @method static _IH_OrderWorkHistory_QB with(array|string $relations)
     * @method _IH_OrderWorkHistory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OrderWorkHistory_C|OrderWorkHistory[] all($columns = ['*'])
     * @ownLinks order_id,\App\Models\Order,id
     * @mixin _IH_OrderWorkHistory_QB
     */
    class OrderWorkHistory extends Model {}
    
    /**
     * @property int $id
     * @property string|null $addon_name
     * @property string|null $addon_type
     * @property string|null $addon_namespace
     * @property string|null $addon_location
     * @property int|null $addon_order
     * @property int|null $addon_page_id
     * @property string|null $addon_page_type
     * @property string|null $addon_settings
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_PageBuilder_QB onWriteConnection()
     * @method _IH_PageBuilder_QB newQuery()
     * @method static _IH_PageBuilder_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_PageBuilder_QB query()
     * @method static _IH_PageBuilder_QB with(array|string $relations)
     * @method _IH_PageBuilder_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PageBuilder_C|PageBuilder[] all($columns = ['*'])
     * @mixin _IH_PageBuilder_QB
     */
    class PageBuilder extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $username
     * @property string $image
     * @property string $title
     * @property string $description
     * @property string|null $published_date
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $load_from
     * @property int $is_synced
     * @property int $status 0=pending, 1=active, 2=rejected
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Portfolio_QB onWriteConnection()
     * @method _IH_Portfolio_QB newQuery()
     * @method static _IH_Portfolio_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Portfolio_QB query()
     * @method static _IH_Portfolio_QB with(array|string $relations)
     * @method _IH_Portfolio_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Portfolio_C|Portfolio[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_Portfolio_QB
     */
    class Portfolio extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $title
     * @property string $description
     * @property string $image
     * @property string $basic_title
     * @property string|null $standard_title
     * @property string|null $premium_title
     * @property string|null $basic_revision
     * @property string|null $standard_revision
     * @property string|null $premium_revision
     * @property string|null $basic_delivery
     * @property string|null $standard_delivery
     * @property string|null $premium_delivery
     * @property float $basic_regular_charge
     * @property float|null $basic_discount_charge
     * @property float|null $standard_regular_charge
     * @property float|null $standard_discount_charge
     * @property float|null $premium_regular_charge
     * @property float|null $premium_discount_charge
     * @property int $project_on_off 0=off, 1=on
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string $slug
     * @property int $status o=pending, 1=approve
     * @property int $project_approve_request 0=request for approve, 1=approve,2=2 will change to 0 when the user edit the project.
     * @property int $category_id
     * @property int|null $offer_packages_available_or_not
     * @property string|null $is_pro
     * @property Carbon|null $pro_expire_date
     * @property string|null $meta_title
     * @property string|null $meta_description
     * @property string|null $meta_tags
     * @property int $load_from
     * @property int $is_synced
     * @property string|null $video
     * @property-read bool $is_pro_project attribute
     * @property _IH_Order_C|Order[] $complete_orders
     * @property-read int $complete_orders_count
     * @method HasMany|_IH_Order_QB complete_orders()
     * @property MetaData $metaData
     * @method MorphToMany|_IH_MetaData_QB metaData()
     * @property _IH_Order_C|Order[] $orders
     * @property-read int $orders_count
     * @method HasMany|_IH_Order_QB orders()
     * @property _IH_ProjectAttribute_C|ProjectAttribute[] $project_attributes
     * @property-read int $project_attributes_count
     * @method HasMany|_IH_ProjectAttribute_QB project_attributes()
     * @property Category $project_category
     * @method BelongsTo|_IH_Category_QB project_category()
     * @property User $project_creator
     * @method BelongsTo|_IH_User_QB project_creator()
     * @property ProjectHistory $project_history
     * @method HasOne|_IH_ProjectHistory_QB project_history()
     * @property _IH_SubCategory_C|SubCategory[] $project_sub_categories
     * @property-read int $project_sub_categories_count
     * @method BelongsToMany|_IH_SubCategory_QB project_sub_categories()
     * @property _IH_Rating_C|Rating[] $ratings
     * @property-read int $ratings_count
     * @method HasManyThrough|_IH_Rating_QB ratings()
     * @method static _IH_Project_QB onWriteConnection()
     * @method _IH_Project_QB newQuery()
     * @method static _IH_Project_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Project_QB query()
     * @method static _IH_Project_QB with(array|string $relations)
     * @method _IH_Project_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Project_C|Project[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id|category_id,\Modules\Service\Entities\Category,id
     * @foreignLinks id,\App\Models\ProjectHistory,project_id|id,\App\Models\ProjectSubCategory,project_id
     * @mixin _IH_Project_QB
     */
    class Project extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $create_project_id
     * @property string|null $type
     * @property string|null $check_numeric_title
     * @property string|null $basic_check_numeric
     * @property string|null $standard_check_numeric
     * @property string|null $premium_check_numeric
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_ProjectAttribute_QB onWriteConnection()
     * @method _IH_ProjectAttribute_QB newQuery()
     * @method static _IH_ProjectAttribute_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_ProjectAttribute_QB query()
     * @method static _IH_ProjectAttribute_QB with(array|string $relations)
     * @method _IH_ProjectAttribute_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProjectAttribute_C|ProjectAttribute[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_ProjectAttribute_QB
     */
    class ProjectAttribute extends Model {}
    
    /**
     * @property int $id
     * @property int $project_id
     * @property int $user_id
     * @property int|null $reject_count
     * @property int|null $edit_count
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $reject_reason
     * @property Project $project
     * @method HasOne|_IH_Project_QB project()
     * @method static _IH_ProjectHistory_QB onWriteConnection()
     * @method _IH_ProjectHistory_QB newQuery()
     * @method static _IH_ProjectHistory_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_ProjectHistory_QB query()
     * @method static _IH_ProjectHistory_QB with(array|string $relations)
     * @method _IH_ProjectHistory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProjectHistory_C|ProjectHistory[] all($columns = ['*'])
     * @ownLinks project_id,\App\Models\Project,id|user_id,\App\Models\User,id
     * @mixin _IH_ProjectHistory_QB
     */
    class ProjectHistory extends Model {}
    
    /**
     * @method static _IH_ProjectIntroduction_QB onWriteConnection()
     * @method _IH_ProjectIntroduction_QB newQuery()
     * @method static _IH_ProjectIntroduction_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_ProjectIntroduction_QB query()
     * @method static _IH_ProjectIntroduction_QB with(array|string $relations)
     * @method _IH_ProjectIntroduction_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProjectIntroduction_C|ProjectIntroduction[] all($columns = ['*'])
     * @mixin _IH_ProjectIntroduction_QB
     */
    class ProjectIntroduction extends Model {}
    
    /**
     * @property int $id
     * @property int $project_id
     * @property int $sub_category_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_ProjectSubCategory_QB onWriteConnection()
     * @method _IH_ProjectSubCategory_QB newQuery()
     * @method static _IH_ProjectSubCategory_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_ProjectSubCategory_QB query()
     * @method static _IH_ProjectSubCategory_QB with(array|string $relations)
     * @method _IH_ProjectSubCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProjectSubCategory_C|ProjectSubCategory[] all($columns = ['*'])
     * @ownLinks project_id,\App\Models\Project,id|sub_category_id,\Modules\Service\Entities\SubCategory,id
     * @mixin _IH_ProjectSubCategory_QB
     */
    class ProjectSubCategory extends Model {}
    
    /**
     * @property int $id
     * @property int $order_id
     * @property int $sender_id
     * @property int $sender_type 1=client, 2=freelancer
     * @property float $rating
     * @property string|null $review_feedback
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Order $order
     * @method BelongsTo|_IH_Order_QB order()
     * @property _IH_Rating_C|Rating[] $rating_details
     * @property-read int $rating_details_count
     * @method HasMany|_IH_Rating_QB rating_details()
     * @property User $sender
     * @method BelongsTo|_IH_User_QB sender()
     * @method static _IH_Rating_QB onWriteConnection()
     * @method _IH_Rating_QB newQuery()
     * @method static _IH_Rating_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Rating_QB query()
     * @method static _IH_Rating_QB with(array|string $relations)
     * @method _IH_Rating_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Rating_C|Rating[] all($columns = ['*'])
     * @ownLinks order_id,\App\Models\Order,id
     * @foreignLinks id,\App\Models\RatingDetails,rating_id
     * @mixin _IH_Rating_QB
     */
    class Rating extends Model {}
    
    /**
     * @property int $id
     * @property int $rating_id
     * @property string|null $type skill,availability,communication,deadline,quality,co-operation
     * @property int|null $rating
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_RatingDetails_QB onWriteConnection()
     * @method _IH_RatingDetails_QB newQuery()
     * @method static _IH_RatingDetails_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_RatingDetails_QB query()
     * @method static _IH_RatingDetails_QB with(array|string $relations)
     * @method _IH_RatingDetails_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RatingDetails_C|RatingDetails[] all($columns = ['*'])
     * @ownLinks rating_id,\App\Models\Rating,id
     * @mixin _IH_RatingDetails_QB
     */
    class RatingDetails extends Model {}
    
    /**
     * @property int $id
     * @property int|null $order_id
     * @property int $client_id
     * @property int $freelancer_id
     * @property string|null $reporter freelancer, client
     * @property string $title
     * @property string $description
     * @property int|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $note
     * @method static _IH_Report_QB onWriteConnection()
     * @method _IH_Report_QB newQuery()
     * @method static _IH_Report_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Report_QB query()
     * @method static _IH_Report_QB with(array|string $relations)
     * @method _IH_Report_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Report_C|Report[] all($columns = ['*'])
     * @ownLinks order_id,\App\Models\Order,id
     * @mixin _IH_Report_QB
     */
    class Report extends Model {}
    
    /**
     * @property int $id
     * @property string $skill
     * @property string $category_id
     * @property string|null $sub_category_id
     * @property int $status 0=inactive 1=active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Category $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property _IH_JobPost_C|JobPost[] $jobs
     * @property-read int $jobs_count
     * @method BelongsToMany|_IH_JobPost_QB jobs()
     * @property SubCategory|null $subcategory
     * @method BelongsTo|_IH_SubCategory_QB subcategory()
     * @method static _IH_Skill_QB onWriteConnection()
     * @method _IH_Skill_QB newQuery()
     * @method static _IH_Skill_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Skill_QB query()
     * @method static _IH_Skill_QB with(array|string $relations)
     * @method _IH_Skill_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Skill_C|Skill[] all($columns = ['*'])
     * @ownLinks category_id,\Modules\Service\Entities\Category,id|sub_category_id,\Modules\Service\Entities\SubCategory,id
     * @foreignLinks id,\App\Models\JobSkill,skill_id|id,\App\Models\JobPostSkill,skill_id
     * @mixin _IH_Skill_QB
     */
    class Skill extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $profile_link
     * @property string $followers
     * @property string|null $platform_icon
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $is_default
     * @method static _IH_SocialProfile_QB onWriteConnection()
     * @method _IH_SocialProfile_QB newQuery()
     * @method static _IH_SocialProfile_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_SocialProfile_QB query()
     * @method static _IH_SocialProfile_QB with(array|string $relations)
     * @method _IH_SocialProfile_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SocialProfile_C|SocialProfile[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_SocialProfile_QB
     */
    class SocialProfile extends Model {}
    
    /**
     * @property int $id
     * @property string $option_name
     * @property string|null $option_value
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_StaticOption_QB onWriteConnection()
     * @method _IH_StaticOption_QB newQuery()
     * @method static _IH_StaticOption_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_StaticOption_QB query()
     * @method static _IH_StaticOption_QB with(array|string $relations)
     * @method _IH_StaticOption_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_StaticOption_C|StaticOption[] all($columns = ['*'])
     * @mixin _IH_StaticOption_QB
     */
    class StaticOption extends Model {}
    
    /**
     * @property int $id
     * @property int $sub_category_id
     * @property int $user_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_SubCategoryUser_QB onWriteConnection()
     * @method _IH_SubCategoryUser_QB newQuery()
     * @method static _IH_SubCategoryUser_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_SubCategoryUser_QB query()
     * @method static _IH_SubCategoryUser_QB with(array|string $relations)
     * @method _IH_SubCategoryUser_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SubCategoryUser_C|SubCategoryUser[] all($columns = ['*'])
     * @ownLinks sub_category_id,\Modules\Service\Entities\SubCategory,id|user_id,\App\Models\User,id
     * @mixin _IH_SubCategoryUser_QB
     */
    class SubCategoryUser extends Model {}
    
    /**
     * @property int $id
     * @property string $first_name
     * @property string $last_name
     * @property string $email
     * @property string|null $phone
     * @property string $username
     * @property string $password
     * @property string|null $image
     * @property int|null $country_id
     * @property int|null $state_id
     * @property int|null $city_id
     * @property int $user_type 1:client, 2:freelancer
     * @property int $user_active_inactive_status 0:inactive, 1:active
     * @property int $user_verified_status 0:not verified, 1:verified
     * @property int $terms_condition
     * @property string|null $about
     * @property string $is_email_verified 0: not verified, 1:verified
     * @property string|null $google_id
     * @property string|null $facebook_id
     * @property string|null $github_id
     * @property string|null $email_verify_token
     * @property Carbon|null $email_verified_at
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property float $hourly_rate
     * @property Carbon|null $deleted_at
     * @property Carbon|null $check_online_status
     * @property int $check_work_availability
     * @property string|null $google_2fa_secret
     * @property int $google_2fa_enable_disable_disable 0=disable 1=enable
     * @property string $experience_level
     * @property int $is_suspend 0=no , 1=yes
     * @property string|null $firebase_device_token
     * @property string|null $apple_id
     * @property string|null $is_pro
     * @property Carbon|null $pro_expire_date
     * @property string|null $freeze_withdraw
     * @property string|null $freeze_project
     * @property string|null $freeze_job
     * @property string|null $freeze_chat
     * @property string|null $freeze_order_create
     * @property int $load_from
     * @property int $is_synced
     * @property string|null $gender
     * @property bool $phone_otp_verify 0 = not verified, 1 = verified
     * @property string|null $phone_otp_code Stores the OTP code for phone verification
     * @property Carbon|null $phone_otp_expiration Stores the expiration time for the OTP code
     * @property float|null $engagement_rate
     * @property int|null $avg_views
     * @property int|null $estimated_reach
     * @property-read int $credit_balance attribute
     * @property-read string $fullname attribute
     * @property-read bool $is_pro_freelancer attribute
     * @property IndividualCommissionSetting $admin_commission
     * @method HasOne|_IH_IndividualCommissionSetting_QB admin_commission()
     * @property _IH_Category_C|Category[] $categories
     * @property-read int $categories_count
     * @method BelongsToMany|_IH_Category_QB categories()
     * @property _IH_LiveChatMessage_C|LiveChatMessage[] $client_unseen_message
     * @property-read int $client_unseen_message_count
     * @method HasManyThrough|_IH_LiveChatMessage_QB client_unseen_message()
     * @property _IH_Credit_C|Credit[] $credits
     * @property-read int $credits_count
     * @method HasMany|_IH_Credit_QB credits()
     * @property _IH_Feedback_C|Feedback[] $feedbacks
     * @property-read int $feedbacks_count
     * @method HasMany|_IH_Feedback_QB feedbacks()
     * @property _IH_UserWork_C|UserWork[] $freelancer_category
     * @property-read int $freelancer_category_count
     * @method HasMany|_IH_UserWork_QB freelancer_category()
     * @property _IH_Order_C|Order[] $freelancer_orders
     * @property-read int $freelancer_orders_count
     * @method HasMany|_IH_Order_QB freelancer_orders()
     * @property _IH_Rating_C|Rating[] $freelancer_ratings
     * @property-read int $freelancer_ratings_count
     * @method HasManyThrough|_IH_Rating_QB freelancer_ratings()
     * @property _IH_UserSkill_C|UserSkill[] $freelancer_skill
     * @property-read int $freelancer_skill_count
     * @method HasMany|_IH_UserSkill_QB freelancer_skill()
     * @property _IH_LiveChatMessage_C|LiveChatMessage[] $freelancer_unseen_message
     * @property-read int $freelancer_unseen_message_count
     * @method HasManyThrough|_IH_LiveChatMessage_QB freelancer_unseen_message()
     * @property IdentityVerification $identity_verify
     * @method HasOne|_IH_IdentityVerification_QB identity_verify()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property _IH_Permission_C|Permission[] $permissions
     * @property-read int $permissions_count
     * @method MorphToMany|_IH_Permission_QB permissions()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property _IH_Role_C|Role[] $roles
     * @property-read int $roles_count
     * @method MorphToMany|_IH_Role_QB roles()
     * @property _IH_SocialProfile_C|SocialProfile[] $social_profiles
     * @property-read int $social_profiles_count
     * @method HasMany|_IH_SocialProfile_QB social_profiles()
     * @property _IH_PersonalAccessToken_C|PersonalAccessToken[] $tokens
     * @property-read int $tokens_count
     * @method MorphToMany|_IH_PersonalAccessToken_QB tokens()
     * @property _IH_User_C|User[] $unlockedBy
     * @property-read int $unlocked_by_count
     * @method BelongsToMany|_IH_User_QB unlockedBy()
     * @property _IH_User_C|User[] $unlockedInfluencers
     * @property-read int $unlocked_influencers_count
     * @method BelongsToMany|_IH_User_QB unlockedInfluencers()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @property UserCredit $userCredit
     * @method HasOne|_IH_UserCredit_QB userCredit()
     * @property City|null $user_city
     * @method BelongsTo|_IH_City_QB user_city()
     * @property _IH_Order_C|Order[] $user_complete_orders
     * @property-read int $user_complete_orders_count
     * @method HasMany|_IH_Order_QB user_complete_orders()
     * @property Country|null $user_country
     * @method BelongsTo|_IH_Country_QB user_country()
     * @property UserEarning $user_earning
     * @method HasOne|_IH_UserEarning_QB user_earning()
     * @property UserIntroduction $user_introduction
     * @method HasOne|_IH_UserIntroduction_QB user_introduction()
     * @property _IH_JobPost_C|JobPost[] $user_jobs
     * @property-read int $user_jobs_count
     * @method HasMany|_IH_JobPost_QB user_jobs()
     * @property State|null $user_state
     * @method BelongsTo|_IH_State_QB user_state()
     * @property Wallet $user_wallet
     * @method HasOne|_IH_Wallet_QB user_wallet()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all($columns = ['*'])
     * @ownLinks country_id,\Modules\CountryManage\Entities\Country,id|state_id,\Modules\CountryManage\Entities\State,id|city_id,\Modules\CountryManage\Entities\City,id
     * @foreignLinks id,\Modules\Blog\Entities\BlogComment,user_id|id,\Modules\Credit\App\Models\Credit,user_id|id,\Modules\Credit\App\Models\UserCredit,user_id|id,\Modules\Credit\App\Models\UnlockedInfluencer,client_id|id,\Modules\Credit\App\Models\UnlockedInfluencer,influencer_id|id,\App\Models\MediaUpload,user_id|id,\App\Models\UserIntroduction,user_id|id,\App\Models\UserExperience,user_id|id,\App\Models\UserEducation,user_id|id,\App\Models\UserWork,user_id|id,\App\Models\UserSkill,user_id|id,\App\Models\IdentityVerification,user_id|id,\App\Models\Project,user_id|id,\App\Models\ProjectAttribute,user_id|id,\App\Models\Portfolio,user_id|id,\App\Models\ProjectHistory,user_id|id,\App\Models\AdminNotification,user_id|id,\Modules\Wallet\Entities\Wallet,user_id|id,\Modules\Wallet\Entities\WalletHistory,user_id|id,\App\Models\JobHistory,user_id|id,\Modules\Subscription\Entities\UserSubscription,user_id|id,\App\Models\Order,user_id|id,\App\Models\UserEarning,user_id|id,\App\Models\IndividualCommissionSetting,user_id|id,\App\Models\JobPost,user_id|id,\Modules\Wallet\Entities\WithdrawRequest,user_id|id,\App\Models\Feedback,user_id|id,\App\Models\Bookmark,user_id|id,\Modules\PromoteInfluencer\Entities\PromotionProjectList,user_id|id,\Modules\SecurityManage\Entities\LogActivity,user_id|id,\App\Models\SocialProfile,user_id|id,\App\Models\UserLang,user_id|id,\App\Models\CategoryUser,user_id|id,\App\Models\SubCategoryUser,user_id
     * @mixin _IH_User_QB
     * @method static UserFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class User extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property float $total_earning
     * @property float $total_withdraw
     * @property float $remaining_balance
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property bool $show_earning
     * @method static _IH_UserEarning_QB onWriteConnection()
     * @method _IH_UserEarning_QB newQuery()
     * @method static _IH_UserEarning_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_UserEarning_QB query()
     * @method static _IH_UserEarning_QB with(array|string $relations)
     * @method _IH_UserEarning_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserEarning_C|UserEarning[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_UserEarning_QB
     */
    class UserEarning extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $institution
     * @property string $degree
     * @property string $subject
     * @property Carbon|null $start_date
     * @property Carbon|null $end_date
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_UserEducation_QB onWriteConnection()
     * @method _IH_UserEducation_QB newQuery()
     * @method static _IH_UserEducation_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_UserEducation_QB query()
     * @method static _IH_UserEducation_QB with(array|string $relations)
     * @method _IH_UserEducation_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserEducation_C|UserEducation[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_UserEducation_QB
     */
    class UserEducation extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $title
     * @property string $short_description
     * @property string $organization
     * @property string $address
     * @property string $country_id
     * @property string $state_id
     * @property Carbon|null $start_date
     * @property Carbon|null $end_date
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_UserExperience_QB onWriteConnection()
     * @method _IH_UserExperience_QB newQuery()
     * @method static _IH_UserExperience_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_UserExperience_QB query()
     * @method static _IH_UserExperience_QB with(array|string $relations)
     * @method _IH_UserExperience_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserExperience_C|UserExperience[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id|country_id,\Modules\CountryManage\Entities\Country,id|state_id,\Modules\CountryManage\Entities\State,id
     * @mixin _IH_UserExperience_QB
     */
    class UserExperience extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $description
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_UserIntroduction_QB onWriteConnection()
     * @method _IH_UserIntroduction_QB newQuery()
     * @method static _IH_UserIntroduction_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_UserIntroduction_QB query()
     * @method static _IH_UserIntroduction_QB with(array|string $relations)
     * @method _IH_UserIntroduction_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserIntroduction_C|UserIntroduction[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_UserIntroduction_QB
     */
    class UserIntroduction extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $lang
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_UserLang_QB onWriteConnection()
     * @method _IH_UserLang_QB newQuery()
     * @method static _IH_UserLang_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_UserLang_QB query()
     * @method static _IH_UserLang_QB with(array|string $relations)
     * @method _IH_UserLang_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserLang_C|UserLang[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_UserLang_QB
     */
    class UserLang extends Model {}
    
    /**
     * @property int $id
     * @property int $identity
     * @property int $client_id
     * @property int $freelancer_id
     * @property string $type
     * @property string $message
     * @property string $is_client_read
     * @property string $is_freelancer_read
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_UserNotification_QB onWriteConnection()
     * @method _IH_UserNotification_QB newQuery()
     * @method static _IH_UserNotification_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_UserNotification_QB query()
     * @method static _IH_UserNotification_QB with(array|string $relations)
     * @method _IH_UserNotification_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserNotification_C|UserNotification[] all($columns = ['*'])
     * @mixin _IH_UserNotification_QB
     */
    class UserNotification extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $skill
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_UserSkill_QB onWriteConnection()
     * @method _IH_UserSkill_QB newQuery()
     * @method static _IH_UserSkill_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_UserSkill_QB query()
     * @method static _IH_UserSkill_QB with(array|string $relations)
     * @method _IH_UserSkill_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserSkill_C|UserSkill[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_UserSkill_QB
     */
    class UserSkill extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $category_id
     * @property int|null $sub_category_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Category $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property SubCategory|null $sub_category
     * @method BelongsTo|_IH_SubCategory_QB sub_category()
     * @method static _IH_UserWork_QB onWriteConnection()
     * @method _IH_UserWork_QB newQuery()
     * @method static _IH_UserWork_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_UserWork_QB query()
     * @method static _IH_UserWork_QB with(array|string $relations)
     * @method _IH_UserWork_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserWork_C|UserWork[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id|category_id,\Modules\Service\Entities\Category,id|sub_category_id,\Modules\Service\Entities\SubCategory,id
     * @mixin _IH_UserWork_QB
     */
    class UserWork extends Model {}
    
    /**
     * @property int $id
     * @property string|null $widget_area
     * @property int|null $widget_order
     * @property string|null $widget_location
     * @property string $widget_name
     * @property string $widget_content
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Widget_QB onWriteConnection()
     * @method _IH_Widget_QB newQuery()
     * @method static _IH_Widget_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Widget_QB query()
     * @method static _IH_Widget_QB with(array|string $relations)
     * @method _IH_Widget_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Widget_C|Widget[] all($columns = ['*'])
     * @mixin _IH_Widget_QB
     */
    class Widget extends Model {}
}