<?php //aeb20fb4a5070e3daff0c1af75096fdc
/** @noinspection all */

namespace Modules\Credit\App\Models {

    use App\Models\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Modules\Credit\App\Models\_IH_Credit_C;
    use LaravelIdea\Helper\Modules\Credit\App\Models\_IH_Credit_QB;
    use LaravelIdea\Helper\Modules\Credit\App\Models\_IH_UnlockedInfluencer_C;
    use LaravelIdea\Helper\Modules\Credit\App\Models\_IH_UnlockedInfluencer_QB;
    use LaravelIdea\Helper\Modules\Credit\App\Models\_IH_UserCredit_C;
    use LaravelIdea\Helper\Modules\Credit\App\Models\_IH_UserCredit_QB;
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string|null $payment_gateway
     * @property string $payment_status
     * @property string|null $transaction_id
     * @property string|null $manual_payment_image
     * @property int $credits
     * @property bool $status 1 = active (credited), 0 = failed/cancelled
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Credit_QB onWriteConnection()
     * @method _IH_Credit_QB newQuery()
     * @method static _IH_Credit_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Credit_QB query()
     * @method static _IH_Credit_QB with(array|string $relations)
     * @method _IH_Credit_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Credit_C|Credit[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_Credit_QB
     */
    class Credit extends Model {}
    
    /**
     * @property int $id
     * @property int $client_id
     * @property int $influencer_id
     * @property int $credits_used
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User $client
     * @method BelongsTo|_IH_User_QB client()
     * @property User $influencer
     * @method BelongsTo|_IH_User_QB influencer()
     * @method static _IH_UnlockedInfluencer_QB onWriteConnection()
     * @method _IH_UnlockedInfluencer_QB newQuery()
     * @method static _IH_UnlockedInfluencer_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_UnlockedInfluencer_QB query()
     * @method static _IH_UnlockedInfluencer_QB with(array|string $relations)
     * @method _IH_UnlockedInfluencer_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UnlockedInfluencer_C|UnlockedInfluencer[] all($columns = ['*'])
     * @ownLinks client_id,\App\Models\User,id|influencer_id,\App\Models\User,id
     * @mixin _IH_UnlockedInfluencer_QB
     */
    class UnlockedInfluencer extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $credit_balance
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_UserCredit_QB onWriteConnection()
     * @method _IH_UserCredit_QB newQuery()
     * @method static _IH_UserCredit_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_UserCredit_QB query()
     * @method static _IH_UserCredit_QB with(array|string $relations)
     * @method _IH_UserCredit_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserCredit_C|UserCredit[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_UserCredit_QB
     */
    class UserCredit extends Model {}
}