<?php //f0189360fb5a23a221ece58a8d1f7da5
/** @noinspection all */

namespace Modules\Subscription\Entities {

    use App\Models\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOneThrough;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_SubscriptionFeature_C;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_SubscriptionFeature_QB;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_SubscriptionType_C;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_SubscriptionType_QB;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_Subscription_C;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_Subscription_QB;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_UserSubscription_C;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_UserSubscription_QB;
    
    /**
     * @property int $id
     * @property int $subscription_type_id
     * @property string $title
     * @property string $logo
     * @property float $price
     * @property int $status 1-active, 0-inactive
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $limit
     * @property string $subscription_highlight_color
     * @property string|null $stripe_product_id
     * @property string|null $stripe_price_id
     * @property _IH_SubscriptionFeature_C|SubscriptionFeature[] $features
     * @property-read int $features_count
     * @method HasMany|_IH_SubscriptionFeature_QB features()
     * @property SubscriptionType $subscription_type
     * @method BelongsTo|_IH_SubscriptionType_QB subscription_type()
     * @property _IH_UserSubscription_C|UserSubscription[] $user_subscriptions
     * @property-read int $user_subscriptions_count
     * @method HasMany|_IH_UserSubscription_QB user_subscriptions()
     * @method static _IH_Subscription_QB onWriteConnection()
     * @method _IH_Subscription_QB newQuery()
     * @method static _IH_Subscription_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Subscription_QB query()
     * @method static _IH_Subscription_QB with(array|string $relations)
     * @method _IH_Subscription_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Subscription_C|Subscription[] all($columns = ['*'])
     * @ownLinks subscription_type_id,\Modules\Subscription\Entities\SubscriptionType,id
     * @foreignLinks id,\Modules\Subscription\Entities\SubscriptionFeature,subscription_id|id,\Modules\Subscription\Entities\UserSubscription,subscription_id
     * @mixin _IH_Subscription_QB
     */
    class Subscription extends Model {}
    
    /**
     * @property int $id
     * @property int $subscription_id
     * @property string $feature
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_SubscriptionFeature_QB onWriteConnection()
     * @method _IH_SubscriptionFeature_QB newQuery()
     * @method static _IH_SubscriptionFeature_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_SubscriptionFeature_QB query()
     * @method static _IH_SubscriptionFeature_QB with(array|string $relations)
     * @method _IH_SubscriptionFeature_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SubscriptionFeature_C|SubscriptionFeature[] all($columns = ['*'])
     * @ownLinks subscription_id,\Modules\Subscription\Entities\Subscription,id
     * @mixin _IH_SubscriptionFeature_QB
     */
    class SubscriptionFeature extends Model {}
    
    /**
     * @property int $id
     * @property string $type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $validity
     * @property bool $is_free
     * @property _IH_Subscription_C|Subscription[] $subscriptions
     * @property-read int $subscriptions_count
     * @method HasMany|_IH_Subscription_QB subscriptions()
     * @method static _IH_SubscriptionType_QB onWriteConnection()
     * @method _IH_SubscriptionType_QB newQuery()
     * @method static _IH_SubscriptionType_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_SubscriptionType_QB query()
     * @method static _IH_SubscriptionType_QB with(array|string $relations)
     * @method _IH_SubscriptionType_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SubscriptionType_C|SubscriptionType[] all($columns = ['*'])
     * @foreignLinks id,\Modules\Subscription\Entities\Subscription,subscription_type_id
     * @mixin _IH_SubscriptionType_QB
     */
    class SubscriptionType extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $subscription_id
     * @property float $price
     * @property int $limit
     * @property Carbon|null $expire_date
     * @property string|null $payment_gateway
     * @property string|null $payment_status
     * @property int $status
     * @property string|null $transaction_id
     * @property string|null $manual_payment_image
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $email_send
     * @property string|null $stripe_customer_id
     * @property string|null $stripe_subscription_id
     * @property string|null $stripe_price_id
     * @property string|null $stripe_session_id
     * @property Carbon|null $start_date
     * @property object $is_recurring_subscription
     * @property int|null $target_limit
     * @property Subscription $subscription
     * @method BelongsTo|_IH_Subscription_QB subscription()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @property SubscriptionType $user_subscription_type_api
     * @method HasOneThrough|_IH_SubscriptionType_QB user_subscription_type_api()
     * @method static _IH_UserSubscription_QB onWriteConnection()
     * @method _IH_UserSubscription_QB newQuery()
     * @method static _IH_UserSubscription_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_UserSubscription_QB query()
     * @method static _IH_UserSubscription_QB with(array|string $relations)
     * @method _IH_UserSubscription_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserSubscription_C|UserSubscription[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id|subscription_id,\Modules\Subscription\Entities\Subscription,id
     * @mixin _IH_UserSubscription_QB
     */
    class UserSubscription extends Model {}
}