<?php //932f8ad3f294bc2ce6299db13b383a48
/** @noinspection all */

namespace Modules\SupportTicket\Entities {

    use App\Models\Admin;
    use App\Models\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_Admin_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Modules\SupportTicket\Entities\_IH_ChatMessage_C;
    use LaravelIdea\Helper\Modules\SupportTicket\Entities\_IH_ChatMessage_QB;
    use LaravelIdea\Helper\Modules\SupportTicket\Entities\_IH_Department_C;
    use LaravelIdea\Helper\Modules\SupportTicket\Entities\_IH_Department_QB;
    use LaravelIdea\Helper\Modules\SupportTicket\Entities\_IH_Ticket_C;
    use LaravelIdea\Helper\Modules\SupportTicket\Entities\_IH_Ticket_QB;
    
    /**
     * @property int $id
     * @property int $ticket_id
     * @property string|null $message
     * @property string|null $notify
     * @property string|null $attachment
     * @property string $type admin, client, freelancer
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $load_from
     * @property int $is_synced
     * @property int|null $sender_id ID of the sender (admin, client, freelancer/influencer)
     * @property-read null $admin_sender_or_default attribute
     * @property Admin|null $admin_sender
     * @method BelongsTo|_IH_Admin_QB admin_sender()
     * @property Ticket $ticket
     * @method BelongsTo|_IH_Ticket_QB ticket()
     * @property User|null $user_sender
     * @method BelongsTo|_IH_User_QB user_sender()
     * @method static _IH_ChatMessage_QB onWriteConnection()
     * @method _IH_ChatMessage_QB newQuery()
     * @method static _IH_ChatMessage_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_ChatMessage_QB query()
     * @method static _IH_ChatMessage_QB with(array|string $relations)
     * @method _IH_ChatMessage_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ChatMessage_C|ChatMessage[] all($columns = ['*'])
     * @ownLinks ticket_id,\Modules\SupportTicket\Entities\Ticket,id
     * @mixin _IH_ChatMessage_QB
     */
    class ChatMessage extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property int $status 0=inactive,1=active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Department_QB onWriteConnection()
     * @method _IH_Department_QB newQuery()
     * @method static _IH_Department_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Department_QB query()
     * @method static _IH_Department_QB with(array|string $relations)
     * @method _IH_Department_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Department_C|Department[] all($columns = ['*'])
     * @foreignLinks id,\Modules\SupportTicket\Entities\Ticket,department_id
     * @mixin _IH_Department_QB
     */
    class Department extends Model {}
    
    /**
     * @property int $id
     * @property int $department_id
     * @property int|null $admin_id
     * @property int|null $client_id
     * @property int|null $freelancer_id
     * @property string|null $title
     * @property string|null $subject
     * @property string|null $priority
     * @property string $status
     * @property string|null $via admin, client, freelancer
     * @property string|null $operating_system
     * @property string|null $user_agent
     * @property string $description
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User|null $client
     * @method BelongsTo|_IH_User_QB client()
     * @property User|null $freelancer
     * @method BelongsTo|_IH_User_QB freelancer()
     * @property ChatMessage $get_ticket_latest_message
     * @method HasOne|_IH_ChatMessage_QB get_ticket_latest_message()
     * @property _IH_ChatMessage_C|ChatMessage[] $message
     * @property-read int $message_count
     * @method HasMany|_IH_ChatMessage_QB message()
     * @method static _IH_Ticket_QB onWriteConnection()
     * @method _IH_Ticket_QB newQuery()
     * @method static _IH_Ticket_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Ticket_QB query()
     * @method static _IH_Ticket_QB with(array|string $relations)
     * @method _IH_Ticket_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Ticket_C|Ticket[] all($columns = ['*'])
     * @ownLinks department_id,\Modules\SupportTicket\Entities\Department,id|admin_id,\App\Models\Admin,id
     * @foreignLinks id,\Modules\SupportTicket\Entities\ChatMessage,ticket_id
     * @mixin _IH_Ticket_QB
     */
    class Ticket extends Model {}
}